<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreSlider extends VisualizzatoreComponente {
        private $javascriptAssociato;
        
        function __construct($db) {
            parent::__construct($db);
        }
        
        function generaContenutoSezione($dati) {
            $slider = parent::getDb()->leggiSingolaRiga("geec_slider",$dati["idElemento"]);
            
            $altezzaSlider = $slider["altezza"];
            $idSlider = str_replace(" ", "", $slider["nome"]);
            
            echo "<div class=\"{$slider["spazioOccupato"]}\" >
                <div class=\"slider-new $altezzaSlider\">
                        <div id=\"$idSlider\" class=\"owl-carousel owl-theme\">";
                        $this->stampaSlide($dati);
                    echo"</div>
                </div>
            </div>";
            
            $this->javascriptAssociato = $this->generaJavascriptSlider($slider,$idSlider);
        }
        
        //metodo che crea le slide
        function stampaSlide($dati) {
            $querySlide="SELECT * FROM geec_slide WHERE idSlider={$dati["idElemento"]} ORDER BY posizione";
            $risSlide = parent::getDb()->eseguiQueryLettura($querySlide);

            if($risSlide->num_rows==0) {
                echo"<h2>Attenzione, non sono presenti slide. Crearle dal pannello amministrativo</h2>";
            }

            while($slide=$risSlide->fetch_assoc()) {
                switch ($slide["tipo"]) {
                    case 'soloImmagine':
                        $this->stampaSlideTagImg($slide);
                        break;
                    case 'sfondo':
                        if(strpos($slide["percorsoFileMultimediale"], ".mp4")>0) {                        
                            $this->stampaSlideVideoSfondo($slide);
                        }
                        else {                        
                            $this->stampaSlideConTestoSovrapposto($slide);
                        }
                        break;
                    case 'videoInTag':
                        $this->stampaSlideVideoInTag($slide);
                        break;
                    case 'html':
                        $this->stampaSlideHtml($slide);
                        break;
                }
            }
        }
        
        function stampaSlideTagImg($slide) {
            $codicePulsante = $this->codicePulsante($slide);
            $tagImg   = "<img src=\"{$slide["percorsoFileMultimediale"]}\">";

            if($slide["link"]!="") {
                ?>
                <a href="<?= $slide["link"] ?>">
                    <div class="item background-image slideInTag" > 
                        <?= $tagImg ?>
                        <?php $this->codiceOverlayEGradiente($slide) ?>
                    </div>
                </a>
                <?php
            }
            else {
                ?>
                <div class="item background-image slideInTag">
                    <?= $tagImg ?>
                    <?php $this->codiceOverlayEGradiente($slide) ?>
                </div>
                <?php
            }
        }
        
        function stampaSlideConTestoSovrapposto($slide) {
            $stileDiv = "style=\"background-image: url('{$slide["percorsoFileMultimediale"]}')\"";
            
            $codicePulsante = $this->codicePulsante($slide);
            if($slide["link"]!=""){
                ?>
                <a href="<?= $slide["link"] ?>">
                   <div class="item background-image" <?= $stileDiv ?>>
                        <div class="contenuto text-white text-center">
                            <?= $slide["testo"] ?>
                            <?= $codicePulsante ?>
                        </div>
                        <?php $this->codiceOverlayEGradiente($slide) ?>
                    </div>
               </a>
                <?php
            }
            else {
                ?>
                <div class="item background-image" <?= $stileDiv ?>>
                    <div class="contenuto text-white text-center">
                        <?= $slide["testo"] ?>
                        <?= $codicePulsante ?>
                    </div>
                    <?php $this->codiceOverlayEGradiente($slide) ?>
                </div>
                <?php
            }
        }
        
        function stampaSlideVideoSfondo($slide) {
            $codicePulsante = $this->codicePulsante($slide);
            $codiceVideoSfondo    = "data-vide-bg=\"mp4: {$slide["percorsoFileMultimediale"]}\" data-vide-options=\"posterType: jpg, loop: true, muted: true, position: 50% 50%\"";
            
            if($slide["link"]!="") {
                ?>
                <a href="<?= $slide["link"] ?>">
                   <div class="item background-image" <?= $codiceVideoSfondo ?> > 
                        <div class="contenuto text-white text-center">
                            <?= $slide["testo"] ?>
                            <?= $codicePulsante ?>
                        </div>
                        <?php $this->codiceOverlayEGradiente($slide) ?>
                   </div>
               </a>
                <?php
            }
            else {
                ?>
                <div class="item background-image" <?= $codiceVideoSfondo ?>>
                    <div class="contenuto text-white text-center">
                        <?= $slide["testo"] ?>
                        <?= $codicePulsante ?>
                    </div>
                    <?php $this->codiceOverlayEGradiente($slide) ?>
                </div>
                <?php
            }
        }
        
        function stampaSlideVideoInTag($slide) {
            $codicePulsante = $this->codicePulsante($slide);
            $codiceVideoTag = "<video controls > 
                                    <source src=\"{$slide["percorsoFileMultimediale"]}\">
                                </video>";
            
            if($slide["link"]!="") {
                ?>
                <a href="<?= $slide["link"] ?>">
                   <div class="item background-image slideInTag" > 
                        <?= $codiceVideoTag ?>
                        <?php $this->codiceOverlayEGradiente($slide) ?>
                   </div>
                </a>
                <?php
            }
            else {
                ?>
                <div class="item background-image slideInTag">
                    <?= $codiceVideoTag ?>
                    <?php $this->codiceOverlayEGradiente($slide) ?>
                </div>
                <?php
            }
        }
        
        function stampaSlideHtml($slide) {
            ?>
            <div class="item background-image" >
                <?php
                    if($slide["link"]!=""){
                        echo "<a href=\"{$slide["link"]}\">
                            {$slide["testo"]}
                       </a>\n";
                    }
                    else {
                        
                        echo "<div>{$slide["testo"]}</div>";
                    }

                    $this->codiceOverlayEGradiente($slide);
                ?>
            </div>
            <?php
        }
        
        function codiceOverlayEGradiente($slide) {
            if($slide["overlay"]=="si") {
                ?>
                <div class="overlay"></div>
                <?php
            }
            
            if($slide["gradiente"]=="si") {
                ?>
                <div class="dark-gradient"></div>
                <?php
            }
        }
        
        function codicePulsante($slide) {
            if($slide["linkPulsante"]!="") {
                return "<button type=\"button\" class=\"{$slide["stilePulsante"]}\" onclick=gestisciClick({$slide["id"]},'{$slide["linkPulsante"]}','incrementaClickSlide')> {$slide["titoloPulsante"]}</button>";
            }
            else {
                return "";
            }
        }
        
        function generaJavascriptSlider($slider,$idSlider) {
            // ad ogni transizione in entrata è associata una transizione in uscita
            $transizioniUscita = array(
                "none"=>"none",
                "slideInRight"=>"slideOutLeft",
                "fadeIn"=>"fadeOut",
                "fadeInDown"=>"fadeOutDown",
                "flipInX"=>"slideOutDown",
                "flipInY"=>"slideOutRight",
                "zoomIn"=>"zoomOut");
            
            $disposizioneElementi = $this->generaIstruzioniDisposizioneElementi($slider);
            $mostraFreccette = ($slider["mostraFreccette"]=="si") ? "true" : "false";
            $mostraPuntiNavicazione = ($slider["mostraPuntiNavigazione"]=="si") ? "true" : "false";
            $autoPlay        = ($slider["autoplay"]=="si") ? "true" : "false";
            $pausaOnHover    = ($slider["pausaOnHover"]=="si") ? "true" : "false";
            
            if($slider["tipoTransizione"]!="none") {
                $transizioneUscita = $transizioniUscita[$slider["tipoTransizione"]];
                $transizioni = "autoplayHoverPause:$pausaOnHover,
                        animateOut: '$transizioneUscita',";
            }
            else {
                $transizioni = "";
            }
            
            return "<script>
                $(document).ready(function() {
                    $('#$idSlider').owlCarousel({
                        loop:true,
                        autoplay:$autoPlay,
                        autoplayTimeout:{$slider["tempoPermanenzaSingolaSlide"]},
                        $transizioni
                        animateIn: '{$slider["tipoTransizione"]}',
                        $disposizioneElementi
                        nav:$mostraFreccette,
                        dots:$mostraPuntiNavicazione,
                        margin:0,
                        autoHeight:true,
                        stagePadding:0,
                        smartSpeed:450
                    });
                });
            </script>";
            
        }
        
        function generaIstruzioniDisposizioneElementi($slider) {
            if($slider["slideMostrateSuLargeDesktop"] == $slider["slideMostrateSuDesktop"] && $slider["slideMostrateSuDesktop"] == $slider["slideMostrateSuTablet"] && $slider["slideMostrateSuDesktop"] == $slider["slideMostrateSuSmartphone"]) {
                return "items:{$slider["slideMostrateSuDesktop"]},";
            }
            else {
                return "responsive:{
                        0:{
                            items:{$slider["slideMostrateSuSmartphone"]}
                        },
                        600:{
                            items:{$slider["slideMostrateSuTablet"]}
                        },
                        1000:{
                            items:{$slider["slideMostrateSuDesktop"]}
                        },
                        1600:{
                            items:{$slider["slideMostrateSuLargeDesktop"]}
                        }
                    },";
            }
        }
        
        function getJavascriptAssociato() {
            return $this->javascriptAssociato;
        }
    }